//
//  TodoItemRow.swift
//  Do It
//
//  Created by Jim Dovey on 5/20/20.
//  Copyright © 2020 Pragmatic Programmers. All rights reserved.
//

import SwiftUI

struct TodoItemRow: View {
    let item: TodoItem
    // START:ShowAlert
    @State var showAlert = false
    
    var body: some View {
        // START:CompletionButton
        HStack {
            // START:PresentAlert
            Button(action: {
                // END:ShowAlert
                // <literal:elide> ... </literal:elide>
                // END:PresentAlert
                // END:CompletionButton
                // START:ShowAlert
                self.showAlert.toggle()
                // START:CompletionButton
                // START:PresentAlert
            }) {
                // END:CompletionButton
                // <literal:elide> ... </literal:elide>
                // END:PresentAlert
                // START:CompletionButton
                // END:ShowAlert
                Image(systemName: item.complete
                        ? "largecircle.fill.circle"
                        : "circle")
                    .imageScale(.large)
                    .foregroundColor(.accentColor)
                // START:ShowAlert
                // START:PresentAlert
            }
            .padding(.trailing, 6)
            // END:ShowAlert
            // END:CompletionButton
            // END:PresentAlert
            .buttonStyle(HighPriorityButtonStyle())
            // START:PresentAlert
            // START_HIGHLIGHT
            .alert(isPresented: $showAlert) {
                Alert(title: Text("Complete!"),
                      message: Text("This will work soon, honest."),
                      dismissButton: .default(Text("OK")))
            }
            // END_HIGHLIGHT
            // END:PresentAlert
            // START:ShowAlert
            // <literal:elide> ... </literal:elide>
            // END:ShowAlert
            // START:CompletionButton
            
            VStack(alignment: .leading) {
                // <literal:elide> ... </literal:elide>
                // END:CompletionButton
                Text(item.title)
                    .font(.headline)
                
                if item.notes != nil {
                    Text(item.notes!)
                        .font(.subheadline)
                }
                // START:CompletionButton
            }
            // START:ShowAlert
        }
        // END:CompletionButton
    }
    // END:ShowAlert
}

struct TodoItemRow_Previews: PreviewProvider {
    static var previews: some View {
        TodoItemRow(item: defaultTodoItems[0])
            .previewLayout(.sizeThatFits)
    }
}
